/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.ui.cursor;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.utils.ScreenUtils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import technology.rocketjump.undermount.assets.TextureAtlasRepository;

@Singleton
public class CursorManager {
    private static final int BUFFER_WIDTH_HEIGHT = 64;
    private final TextureAtlas textureAtlas;
    private final Map<String, Cursor> cursorsByName = new HashMap<String, Cursor>();

    @Inject
    public CursorManager(TextureAtlasRepository textureAtlasRepository) {
        this.textureAtlas = textureAtlasRepository.get(TextureAtlasRepository.TextureAtlasType.GUI_TEXTURE_ATLAS);
        this.createCursors();
    }

    public void switchToCursor(String cursorName) {
        if (cursorName == null || !this.cursorsByName.containsKey(cursorName)) {
            Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Arrow);
        } else {
            Gdx.graphics.setCursor(this.cursorsByName.get(cursorName));
        }
    }

    private void createCursors() {
        FrameBuffer frameBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, 64, 64, false, false);
        frameBuffer.begin();
        OrthographicCamera camera = new OrthographicCamera(64.0f, 64.0f);
        SpriteBatch batch = new SpriteBatch();
        batch.setProjectionMatrix(camera.combined);
        FileHandle cursorsDir = Gdx.files.internal("assets/ui-skins/cursors");
        for (FileHandle cursorFile : cursorsDir.list()) {
            if (!cursorFile.name().endsWith(".png")) continue;
            this.createCursor(cursorFile.nameWithoutExtension(), cursorFile.path(), batch);
        }
        batch.dispose();
        frameBuffer.end();
        frameBuffer.dispose();
    }

    private void createCursor(String cursorName, String texturePath, SpriteBatch batch) {
        Gdx.gl20.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        Gdx.gl20.glClear(16384);
        Texture cursorImg = new Texture(texturePath);
        batch.begin();
        batch.draw(cursorImg, -32.0f, -32.0f);
        batch.end();
        Pixmap frameBufferPixmap = this.getFrameBufferPixmap();
        Cursor newCursor = Gdx.graphics.newCursor(frameBufferPixmap, 0, 64 - cursorImg.getHeight());
        this.cursorsByName.put(cursorName, newCursor);
        frameBufferPixmap.dispose();
        cursorImg.dispose();
    }

    private Pixmap getFrameBufferPixmap() {
        Pixmap frameBufferPixmap = ScreenUtils.getFrameBufferPixmap(0, 0, 64, 64);
        ByteBuffer pixels = frameBufferPixmap.getPixels();
        int numBytes = 16384;
        byte[] lines = new byte[numBytes];
        int numBytesPerLine = 256;
        for (int i = 0; i < 64; ++i) {
            pixels.position((64 - i - 1) * numBytesPerLine);
            pixels.get(lines, i * numBytesPerLine, numBytesPerLine);
        }
        pixels.clear();
        pixels.put(lines);
        pixels.clear();
        return frameBufferPixmap;
    }
}

